<?php
// Dołączenie PEAR_PackageFileManager2
require_once 'PEAR/PackageFileManager2.php';
// Utworzenie egzemplarza klasy
$package = new PEAR_PackageFileManager2();
// Konfiguracja ustawień domyślnych
$package->setOptions(array(
  'baseinstalldir' => 'Url',
  'packagedirectory' => dirname(__FILE__) . '/Url',
));
// Ustawienie nazwy pakietu
$package->setPackage('Url_Shortener');
// Zwięzły opis pakietu
$package->setSummary('Shorten URLs with a variety of services.');
// Pełny opis pakietu
$package->setDescription('Url_Shortener will let you shorten URLs with Bit.ly, is.gd or Tinyurl');
// Nie mamy jeszcze kanału, ale trzeba podać istniejący, a więc użyjemy po prostu pear.
$package->setChannel('pear.php.net');
// Określenie wersji i stabilności pakietu
$package->setReleaseVersion('0.1.0');
$package->setReleaseStability('alpha');
// Określenie wersji i stabilności API
$package->setApiVersion('0.1.0');
$package->setApiStability('alpha');
// Uwagi do wydania
$package->setNotes('This is the first release of the Url_Shortener package');
// Określenie typu pakietu (ten jest typu PEAR PHP)
$package->setPackageType('php');
// Dodanie sekcji wydania
$package->addRelease();
// Dodanie rozszerzenia pecl_http jako zależności
$package->addPackageDepWithChannel('required', 'pecl_http','pecl.php.net', '1.7.0', false, '1.7.1', false, 'pecl_http');
// Określenie osoby odpowiedzialnej za utrzymanie kodu
$package->addMaintainer('lead', 'dshafik', 'Davey Shafik','me@daveyshafik.com');
// Określenie minimalnej wersji PHP, na któej kod działa
$package->setPhpDep('5.3.6');
// Określenie minimalnego wymogu dotyczącego instalacji PEAR
$package->setPearinstallerDep('1.4.0');
// Dodanie licencji
$package->setLicense('Creative Commons Attribution-ShareAlike 3.0 Unported License', 'http://creativecommons.org/licenses/by-sa/3.0/');
// Wygenerowanie listy plików
$package->generateContents(); 
// Zapis danych w formacie XML w pliku
$package->writePackageFile();

?>
